sub send_packet($) { 
  my ($packet)=@_;

  log_message($packet);
  if($config{'type'} eq 'AX25-BEACON') {
    my $call=$config{'callsign'};
    my $path=$config{'path'};
    my $port=$config{'altport'};
    `beacon -c $call -d 'BEACON via $path' -s $port '$packet'`;
    return;
  }
  
  my ($d1, $d2, $d3, $d4, $rawserver) = gethostbyname($config{'hostname'});
  my $txserveraddr = pack("Sna4x8",2,$config{'port'},$rawserver);
  my $prototype = getprotobyname('udp');
  if($config{'type'} eq 'APRSD') {
    if(socket(SOCKET,2,SOCK_DGRAM,$prototype)) {
      $| = 1;
      send(SOCKET,"N0CLU>TNC:$packet\0",0,$txserveraddr);
      close(SOCKET);
    } else { log_message("Failed to open UDP for APRSD"); }
	return;
  }
  if($config{'type'} eq 'XASTIR') {
    if(socket(SOCKET,2,SOCK_DGRAM,$prototype)) {
      my $message=sprintf("%s,%s,-to_rf\n%s>BEACON:%s\n",$config{'callsign'},$config{'passcode'},$config{'callsign'},$packet);
      $| = 1;
      send(SOCKET,$message,0,$txserveraddr);
      close(SOCKET);
    } else { log_message("Failed to open UDP for Xastir"); }
    return;
  }
  my $prototype = getprotobyname('tcp');
  if($config{'type'} eq 'APRS-IS') {
    my $login=sprintf("user %s pass %s vers dxsat_pdk 0.1\r\n",$config{'callsign'},$config{'passcode'});
    my $message=sprintf("%s>BEACON,TCPIP:%s\r\n",$config{'callsign'},$packet);
    if(socket(SOCKET,PF_INET,SOCK_STREAM,$prototype)) {
      $|=1;
      connect(SOCKET,$txserveraddr);
      send(SOCKET,$login,0);
      send(SOCKET,$message,0);
      close(SOCKET);
    } else { log_message("Failed to open TCP for APRS-IS"); }
    return;
  }
  if($config{'type'} eq 'AGWPE') {
    my @path_temp=split(',',$config{'path'});
    my $path='';
    my $count=0;
    foreach my $each_path (@path_temp) {
      $each_path=trim($each_path);
      if(length($each_path)>0) {
        $path=$path.pack('Z10',$each_path);
        $count++;
      }
    }

    my $data=pack('C',$count).$path.$packet;
                            
    my $header=pack('S S S S Z10 Z10 L L',$config{'altport'},0,ord('V'),0,$config{'callsign'},'BEACON',length($data),0);
                                    
    if(socket(SOCKET,PF_INET,SOCK_STREAM,$prototype)) {
      $| = 1;
      connect(SOCKET,$txserveraddr);
      send(SOCKET,$header.$data,0);
      close(SOCKET);
    } else { log_message("Failed to open TCP for AGW Packet Engine"); }
    return;
  }
  log_message("Unknown method set to transmit packets");
}