#!/usr/bin/perl

use Math::Trig;
use Math::Trig ':pi';
use Ham::APRS::FAP qw(parseaprs);

# Wides are direct only with few values,
# bit most digis do obey explicite trace,
# thus any value that user puts on request
# can be accepted.
my %directdigis = (
    'WIDE1-1' => 1,
    'WIDE2-2' => 1,
    'WIDE3-3' => 1,
    'WIDE4-4' => 1,
    'WIDE5-5' => 1,
    'WIDE6-6' => 1,
    'WIDE7-7' => 1,
    'TRACE1-1' => 1,
    'TRACE2-2' => 1,
    'TRACE2-1' => 1,
    'TRACE3-3' => 1,
    'TRACE3-2' => 1,
    'TRACE3-1' => 1,
    'TRACE4-4' => 1,
    'TRACE4-3' => 1,
    'TRACE4-2' => 1,
    'TRACE4-1' => 1,
    'TRACE5-5' => 1,
    'TRACE5-4' => 1,
    'TRACE5-3' => 1,
    'TRACE5-2' => 1,
    'TRACE5-1' => 1,
    'TRACE6-6' => 1,
    'TRACE6-5' => 1,
    'TRACE6-4' => 1,
    'TRACE6-3' => 1,
    'TRACE6-2' => 1,
    'TRACE6-1' => 1,
    'TRACE7-7' => 1,
    'TRACE7-6' => 1,
    'TRACE7-5' => 1,
    'TRACE7-4' => 1,
    'TRACE7-3' => 1,
    'TRACE7-2' => 1,
    'TRACE7-1' => 1,
    'WIDE' => 1,
    'TRACE' => 1,
    'RELAY' => 1,
);

my $pts   = '';
my $all_pts = '';
my $date0 = '';

while (<STDIN>) {
    chomp;
    my $tnc2 = $_;

    my $date = '';
    if ($tnc2 =~ m/^([0-9]{4}-[0-9]{2}-[0-9]{2})\s\S+\s\S+\s+\S\s(.*)$/o) {
	$date = sprintf("%s",$1);
	$tnc2 = $2;
	#printf "date='%s' tnc2='%s'\n",$date,$tnc2;
    }

    # printf("'%s'  '%s'\n",$date,$tnc2);

    # Parser run pick all details out of packets,
    # much more than mere "was digied" would need,
    # but this was originally a tool to plot directly
    # heard positions.

    my %result = ();
    my $rc = parseaprs( $tnc2, \%result );

    if (!$rc) {
	# printf "Unable to parse: '%s'\n",$tnc2;
	next;
    }
    ## Parsed OK
    ##  ...

#    for my $x (sort keys %result) {
#    	printf " %s: %s\n",$x,$result{$x};
#    }

    my $lat = $result{'latitude'};
    my $lon = $result{'longitude'};

    my $d = $result{'digipeaters'};
    if (defined($d)) {
	my @da = @{$d};
	my %ddh = %{$da[0]};
	if (defined(%ddh)) {
	    if ($ddh{'wasdigied'} != 0) {
		# printf "Seen: 'wasdigied' == %d\n", $ddh{'wasdigied'};
		next;
	    }
	    my $c = $ddh{'call'};
	    my $dd = $directdigis{$c};
	    if (!defined($dd)) {
		# printf "Call '%s' not direct digi\n",$c;
		next;
	    }

	    # printf("OK parse of '%s'\n",$tnc2);
	    # printf "  DIGI!\n";
	} else {
	    # Bad parse result, should not happen
	    next;
	}
    } else {
	# No digipeaters defined, must be direct reception!
	# printf("OK parse of '%s'\n",$tnc2);
	# printf "  DIRECT!\n";
    }

    # printf("'%s' '%s'\n",$date,$tnc2);

    printf("lat/lon: %6.3f  %7.3f\n",$lat,$lon);
}

exit 0;
